/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWWSWorkflow;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWUDDIBusinessServiceTableModel
extends AbstractTableModel {
    private String m_internalClassName = "WSWorkflowTableModel";
    private static final int COL_WORKFLOW_NAME = 0;
    private static final int COL_TRANSFER_TIMESTAMP = 1;
    private DateFormat m_dateFormatter = DateFormat.getDateTimeInstance();
    private Vector m_data = null;
    private String[] m_columnNames = new String[]{VWResource.s_workflow, VWResource.s_transferred};

    public VWUDDIBusinessServiceTableModel() {
        this.m_data = null;
    }

    public VWUDDIBusinessServiceTableModel(VWWSWorkflow[] data) {
        this.m_data = new Vector();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                this.m_data.add(data[i]);
            }
        }
    }

    public int getRowCount() {
        if (this.m_data != null) {
            return this.m_data.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getColumnName(int col) {
        if (col < 0 || col >= this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[col];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (this.m_data == null || this.m_data.size() <= row) {
            return null;
        }
        VWWSWorkflow wsWorkflow = (VWWSWorkflow)this.m_data.elementAt(row);
        if (wsWorkflow == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return wsWorkflow.getName();
            }
            case 1: {
                Date timestamp = wsWorkflow.getTimestamp();
                if (timestamp != null) {
                    return this.m_dateFormatter.format(timestamp);
                }
                return null;
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        VWWSWorkflow wsWorkflow;
        if (this.m_data != null && (wsWorkflow = (VWWSWorkflow)this.m_data.elementAt(row)) != null) {
            wsWorkflow.setSelected(!wsWorkflow.isSelected());
        }
    }

    public void setData(VWWSWorkflow[] data) {
        if (this.m_data != null) {
            this.m_data.clear();
        }
        this.m_data = new Vector();
        this.addData(data);
    }

    public void addData(VWWSWorkflow[] data) {
        int sz;
        if (this.m_data == null) {
            this.m_data = new Vector();
        }
        if (data != null && (sz = data.length) > 0) {
            int firstRow = this.m_data.size();
            int lastRow = firstRow + sz;
            for (int i = 0; i < data.length; ++i) {
                this.m_data.add(data[i]);
            }
            this.fireTableRowsInserted(firstRow, lastRow);
        }
    }

    public void addData(Vector data) {
        int sz;
        if (this.m_data == null) {
            this.m_data = new Vector();
        }
        if (data != null && (sz = data.size()) > 0) {
            int firstRow = this.m_data.size();
            int lastRow = firstRow + sz;
            this.m_data.addAll(data);
            this.fireTableRowsInserted(firstRow, lastRow);
        }
    }

    public void addData(VWWSWorkflow data) {
        try {
            if (this.m_data == null) {
                this.m_data = new Vector();
            }
            this.m_data.addElement(data);
            int nRow = this.m_data.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWSWorkflow getWorkflowAt(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            return (VWWSWorkflow)this.m_data.elementAt(row);
        }
        return null;
    }

    public int find(VWWSWorkflow wf) {
        int idx = -1;
        if (this.m_data != null) {
            String name = wf.getName();
            int sz = this.m_data.size();
            for (int ix = 0; ix < sz; ++ix) {
                VWWSWorkflow elem = (VWWSWorkflow)this.m_data.elementAt(ix);
                if (elem.getName().compareTo(name) != 0) continue;
                idx = ix;
                break;
            }
        }
        return idx;
    }

    public VWWSWorkflow[] getData() {
        int sz;
        VWWSWorkflow[] selected = null;
        if (this.m_data != null && this.m_data.size() > 0 && (sz = this.m_data.size()) > 0) {
            selected = new VWWSWorkflow[sz];
            this.m_data.toArray(selected);
        }
        return selected;
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_data == null || nRow < 0 || nRow >= this.m_data.size()) {
                return;
            }
            Object obj = this.m_data.elementAt(nRow);
            if (obj != null) {
                this.m_data.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    void removeReferences() {
        this.m_data = null;
        if (this.m_columnNames != null) {
            for (int i = 0; i < this.m_columnNames.length; ++i) {
                this.m_columnNames[i] = null;
            }
            this.m_columnNames = null;
        }
    }
}

